/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.query.IVWScopeChangeListener;
import filenet.vw.toolkit.utils.query.VWAddRemoveUsersPanel;
import filenet.vw.toolkit.utils.query.VWFilteredAddRemoveUsersPanel;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class VWUserSelectionPanel
extends JPanel
implements IVWScopeChangeListener {
    private IVWUsersAndGroupsPanel m_usersPanel = null;

    public VWUserSelectionPanel(Frame parentFrame, VWSession vwSession) {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            this.m_usersPanel = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredAddRemoveUsersPanel(parentFrame, vwSession) : new VWAddRemoveUsersPanel(vwSession);
            this.add((Component)((JPanel)((Object)this.m_usersPanel)), "Center");
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDisplayName() {
        return VWResource.s_uusers;
    }

    public VWParticipantItem[] getSelectedUsers() {
        Object[] items;
        if (this.m_usersPanel != null && this.m_usersPanel instanceof VWAddRemovePanel && (items = ((VWAddRemovePanel)((Object)this.m_usersPanel)).getSelectedItems()) != null && items.length > 0) {
            VWParticipantItem[] participants = new VWParticipantItem[items.length];
            System.arraycopy(items, 0, participants, 0, items.length);
            return participants;
        }
        return null;
    }

    public void scopeChanged(VWScopeChangeEvent event) {
        try {
            IVWTableDefinition definition = event.getDefinitionObject();
            if (definition == null) {
                return;
            }
            if (definition instanceof VWQueueDefinition) {
                if (this.m_usersPanel instanceof VWAddRemoveUsersPanel) {
                    ((VWAddRemoveUsersPanel)this.m_usersPanel).setSelectedItems(this.getDefaultSelectedItems());
                } else if (this.m_usersPanel instanceof VWFilteredAddRemoveUsersPanel) {
                    ((VWFilteredAddRemoveUsersPanel)this.m_usersPanel).setSelectedItems(this.getDefaultSelectedItems());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWParticipantItem[] getDefaultSelectedItems() {
        VWParticipantItem[] selectedItems = null;
        try {
            selectedItems = new VWParticipantItem[]{new VWParticipantItem(VWResource.s_allUsers, 3)};
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return selectedItems;
    }
}

